/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.oss;

import com.aliyun.oss.ClientException;
import com.aliyun.oss.common.auth.RequestSigner;
import com.aliyun.oss.common.comm.Protocol;
import com.aliyun.oss.common.comm.RetryStrategy;
import com.aliyun.oss.common.comm.SignVersion;
import com.aliyun.oss.common.utils.ResourceManager;
import com.aliyun.oss.common.utils.VersionInfoUtils;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.KeyManager;
import javax.net.ssl.X509TrustManager;

public class ClientConfiguration {
    public static final String DEFAULT_USER_AGENT = VersionInfoUtils.getDefaultUserAgent();
    public static final int DEFAULT_MAX_RETRIES = 3;
    public static final int DEFAULT_CONNECTION_REQUEST_TIMEOUT = -1;
    public static final int DEFAULT_CONNECTION_TIMEOUT = 50000;
    public static final int DEFAULT_SOCKET_TIMEOUT = 50000;
    public static final int DEFAULT_MAX_CONNECTIONS = 1024;
    public static final long DEFAULT_CONNECTION_TTL = -1L;
    public static final long DEFAULT_IDLE_CONNECTION_TIME = 60000L;
    public static final int DEFAULT_VALIDATE_AFTER_INACTIVITY = 2000;
    public static final int DEFAULT_THREAD_POOL_WAIT_TIME = 60000;
    public static final int DEFAULT_REQUEST_TIMEOUT = 300000;
    public static final long DEFAULT_SLOW_REQUESTS_THRESHOLD = 300000L;
    public static final boolean DEFAULT_USE_REAPER = true;
    public static final String DEFAULT_CNAME_EXCLUDE_LIST = "aliyuncs.com,aliyun-inc.com,aliyun.com";
    public static final SignVersion DEFAULT_SIGNATURE_VERSION = SignVersion.V1;
    protected String userAgent = DEFAULT_USER_AGENT;
    protected int maxErrorRetry = 3;
    protected int connectionRequestTimeout = -1;
    protected int connectionTimeout = 50000;
    protected int socketTimeout = 50000;
    protected int maxConnections = 1024;
    protected long connectionTTL = -1L;
    protected boolean useReaper = true;
    protected long idleConnectionTime = 60000L;
    protected Protocol protocol = Protocol.HTTP;
    protected String proxyHost = null;
    protected int proxyPort = -1;
    protected String proxyUsername = null;
    protected String proxyPassword = null;
    protected String proxyDomain = null;
    protected String proxyWorkstation = null;
    protected boolean supportCname = true;
    protected List<String> cnameExcludeList = new ArrayList<String>();
    protected Lock rlock = new ReentrantLock();
    protected boolean sldEnabled = false;
    protected int requestTimeout = 300000;
    protected boolean requestTimeoutEnabled = false;
    protected long slowRequestsThreshold = 300000L;
    protected Map<String, String> defaultHeaders = new LinkedHashMap<String, String>();
    protected boolean crcCheckEnabled = true;
    protected List<RequestSigner> signerHandlers = new LinkedList<RequestSigner>();
    protected SignVersion signatureVersion = DEFAULT_SIGNATURE_VERSION;
    protected long tickOffset = 0L;
    private RetryStrategy retryStrategy;
    private boolean redirectEnable = true;
    private boolean verifySSLEnable = true;
    private KeyManager[] keyManagers = null;
    private X509TrustManager[] x509TrustManagers = null;
    private SecureRandom secureRandom = null;
    private HostnameVerifier hostnameVerifier = null;
    protected boolean logConnectionPoolStats = false;
    protected boolean useSystemPropertyValues = false;
    private boolean extractSettingFromEndpoint = true;
    private boolean verifyObjectStrict = true;
    private boolean tracerEnabled = false;
    private boolean enableAutoCorrectClockSkew = false;
    private KeyStore keyStore = null;

    public ClientConfiguration() {
        ClientConfiguration.AppendDefaultExcludeList(this.cnameExcludeList);
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public void setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public void setProxyPort(int proxyPort) throws ClientException {
        if (proxyPort <= 0) {
            throw new ClientException(ResourceManager.getInstance("common").getString("ParameterIsInvalid"), null);
        }
        this.proxyPort = proxyPort;
    }

    public String getProxyUsername() {
        return this.proxyUsername;
    }

    public void setProxyUsername(String proxyUsername) {
        this.proxyUsername = proxyUsername;
    }

    public String getProxyPassword() {
        return this.proxyPassword;
    }

    public void setProxyPassword(String proxyPassword) {
        this.proxyPassword = proxyPassword;
    }

    public String getProxyDomain() {
        return this.proxyDomain;
    }

    public void setProxyDomain(String proxyDomain) {
        this.proxyDomain = proxyDomain;
    }

    public String getProxyWorkstation() {
        return this.proxyWorkstation;
    }

    public void setProxyWorkstation(String proxyWorkstation) {
        this.proxyWorkstation = proxyWorkstation;
    }

    public int getMaxConnections() {
        return this.maxConnections;
    }

    public void setMaxConnections(int maxConnections) {
        this.maxConnections = maxConnections;
    }

    public int getSocketTimeout() {
        return this.socketTimeout;
    }

    public void setSocketTimeout(int socketTimeout) {
        this.socketTimeout = socketTimeout;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public int getConnectionRequestTimeout() {
        return this.connectionRequestTimeout;
    }

    public void setConnectionRequestTimeout(int connectionRequestTimeout) {
        this.connectionRequestTimeout = connectionRequestTimeout;
    }

    public int getMaxErrorRetry() {
        return this.maxErrorRetry;
    }

    public void setMaxErrorRetry(int maxErrorRetry) {
        this.maxErrorRetry = maxErrorRetry;
    }

    public long getConnectionTTL() {
        return this.connectionTTL;
    }

    public void setConnectionTTL(long connectionTTL) {
        this.connectionTTL = connectionTTL;
    }

    public boolean isUseReaper() {
        return this.useReaper;
    }

    public void setUseReaper(boolean useReaper) {
        this.useReaper = useReaper;
    }

    public long getIdleConnectionTime() {
        return this.idleConnectionTime;
    }

    public void setIdleConnectionTime(long idleConnectionTime) {
        this.idleConnectionTime = idleConnectionTime;
    }

    public Protocol getProtocol() {
        return this.protocol;
    }

    public void setProtocol(Protocol protocol) {
        this.protocol = protocol;
    }

    public List<String> getCnameExcludeList() {
        return Collections.unmodifiableList(this.cnameExcludeList);
    }

    public void setCnameExcludeList(List<String> cnameExcludeList) {
        if (cnameExcludeList == null) {
            throw new IllegalArgumentException("cname exclude list should not be null.");
        }
        this.cnameExcludeList.clear();
        for (String excl : cnameExcludeList) {
            if (excl.trim().isEmpty()) continue;
            this.cnameExcludeList.add(excl);
        }
        ClientConfiguration.AppendDefaultExcludeList(this.cnameExcludeList);
    }

    private static void AppendDefaultExcludeList(List<String> excludeList) {
        String[] excludes;
        for (String excl : excludes = DEFAULT_CNAME_EXCLUDE_LIST.split(",")) {
            if (excl.trim().isEmpty() || excludeList.contains(excl)) continue;
            excludeList.add(excl.trim().toLowerCase());
        }
    }

    public boolean isSupportCname() {
        return this.supportCname;
    }

    public ClientConfiguration setSupportCname(boolean supportCname) {
        this.supportCname = supportCname;
        return this;
    }

    public boolean isSLDEnabled() {
        return this.sldEnabled;
    }

    public ClientConfiguration setSLDEnabled(boolean enabled) {
        this.sldEnabled = enabled;
        return this;
    }

    public int getValidateAfterInactivity() {
        return 2000;
    }

    public boolean isRequestTimeoutEnabled() {
        return this.requestTimeoutEnabled;
    }

    public void setRequestTimeoutEnabled(boolean requestTimeoutEnabled) {
        this.requestTimeoutEnabled = requestTimeoutEnabled;
    }

    public void setRequestTimeout(int requestTimeout) {
        this.requestTimeout = requestTimeout;
    }

    public int getRequestTimeout() {
        return this.requestTimeout;
    }

    public long getSlowRequestsThreshold() {
        return this.slowRequestsThreshold;
    }

    public void setSlowRequestsThreshold(long slowRequestsThreshold) {
        this.slowRequestsThreshold = slowRequestsThreshold;
    }

    public Map<String, String> getDefaultHeaders() {
        return this.defaultHeaders;
    }

    public void setDefaultHeaders(Map<String, String> defaultHeaders) {
        this.defaultHeaders = defaultHeaders;
    }

    public void addDefaultHeader(String key, String value) {
        this.defaultHeaders.put(key, value);
    }

    public boolean isCrcCheckEnabled() {
        return this.crcCheckEnabled;
    }

    public void setCrcCheckEnabled(boolean crcCheckEnabled) {
        this.crcCheckEnabled = crcCheckEnabled;
    }

    public List<RequestSigner> getSignerHandlers() {
        return this.signerHandlers;
    }

    public void setSignerHandlers(List<RequestSigner> signerHandlers) {
        if (signerHandlers == null) {
            return;
        }
        this.signerHandlers.clear();
        for (RequestSigner signer : signerHandlers) {
            if (signer == null) continue;
            this.signerHandlers.add(signer);
        }
    }

    public SignVersion getSignatureVersion() {
        return this.signatureVersion;
    }

    public void setSignatureVersion(SignVersion signatureVersion) {
        this.signatureVersion = signatureVersion;
    }

    public long getTickOffset() {
        return this.tickOffset;
    }

    public void setTickOffset(long epochTicks) {
        long localTime = new Date().getTime();
        this.tickOffset = epochTicks - localTime;
    }

    public RetryStrategy getRetryStrategy() {
        return this.retryStrategy;
    }

    public void setRetryStrategy(RetryStrategy retryStrategy) {
        this.retryStrategy = retryStrategy;
    }

    public boolean isRedirectEnable() {
        return this.redirectEnable;
    }

    public void setRedirectEnable(boolean redirectEnable) {
        this.redirectEnable = redirectEnable;
    }

    public boolean isVerifySSLEnable() {
        return this.verifySSLEnable;
    }

    public void setVerifySSLEnable(boolean verifySSLEnable) {
        this.verifySSLEnable = verifySSLEnable;
    }

    public KeyManager[] getKeyManagers() {
        return this.keyManagers;
    }

    public void setKeyManagers(KeyManager[] keyManagers) {
        this.keyManagers = keyManagers;
    }

    public X509TrustManager[] getX509TrustManagers() {
        return this.x509TrustManagers;
    }

    public void setX509TrustManagers(X509TrustManager[] x509TrustManagers) {
        this.x509TrustManagers = x509TrustManagers;
    }

    public SecureRandom getSecureRandom() {
        return this.secureRandom;
    }

    public void setSecureRandom(SecureRandom secureRandom) {
        this.secureRandom = secureRandom;
    }

    public HostnameVerifier getHostnameVerifier() {
        return this.hostnameVerifier;
    }

    public void setHostnameVerifier(HostnameVerifier hostnameVerifier) {
        this.hostnameVerifier = hostnameVerifier;
    }

    public void setLogConnectionPoolStats(boolean enabled) {
        this.logConnectionPoolStats = enabled;
    }

    public boolean isLogConnectionPoolStatsEnable() {
        return this.logConnectionPoolStats;
    }

    public void setUseSystemPropertyValues(boolean enabled) {
        this.useSystemPropertyValues = enabled;
    }

    public boolean isUseSystemPropertyValues() {
        return this.useSystemPropertyValues;
    }

    public void setExtractSettingFromEndpoint(boolean enabled) {
        this.extractSettingFromEndpoint = enabled;
    }

    public boolean isExtractSettingFromEndpointEnable() {
        return this.extractSettingFromEndpoint;
    }

    public void setVerifyObjectStrictEnable(boolean enabled) {
        this.verifyObjectStrict = enabled;
    }

    public boolean isVerifyObjectStrict() {
        return this.verifyObjectStrict;
    }

    public boolean isTracerEnabled() {
        return this.tracerEnabled;
    }

    public void setTracerEnabled(boolean enabled) {
        this.tracerEnabled = enabled;
    }

    public boolean isEnableAutoCorrectClockSkew() {
        return this.enableAutoCorrectClockSkew;
    }

    public void setEnableAutoCorrectClockSkew(boolean enableAutoCorrectClockSkew) {
        this.enableAutoCorrectClockSkew = enableAutoCorrectClockSkew;
    }

    public KeyStore getKeyStore() {
        return this.keyStore;
    }

    public void setKeyStore(KeyStore keyStore) {
        this.keyStore = keyStore;
    }
}

