/*
 * Decompiled with CFR 0.152.
 */
package com.guthon.plugin.oss.ali.comps;

import com.golden.faas.core.common.cache.SystemRunHook;
import com.golden.faas.core.common.utils.GdFilePath;
import com.golden.faas.run.common.utils.comps.GuthonFileService;
import com.golden.framework.boot.core.components.BaseBusiness;
import com.golden.framework.boot.utils.exception.BaseException;
import com.golden.framework.boot.utils.utils.StringUtil;
import com.guthon.plugin.oss.ali.util.AliOSS;
import java.io.File;
import org.springframework.stereotype.Component;

@Component(value="com.guthon.plugin.oss.ali.comps.AliFileService")
public class AliFileService
extends BaseBusiness
implements GuthonFileService {
    public static final String ID = "com.guthon.plugin.oss.ali.comps.AliFileService";

    public AliFileService() {
        SystemRunHook.addhook(() -> this.init());
    }

    public void init() {
        try {
            this.initFileService();
        }
        catch (Exception e) {
            this.log.error(e.getMessage());
        }
    }

    private void initFileService() {
        String adapter = this.environment.getProperty("guthon.file-service.adapter");
        if (!StringUtil.equals((String)ID, (String)adapter)) {
            this.log.warn("\u5f53\u524d\u8c37\u795e\u670d\u52a1\u914d\u7f6e\u7684\u6587\u4ef6\u670d\u52a1\u4e3a[{}]\u4e0d\u662f\u672c\u670d\u52a1[{}]\u7684\u9002\u914d\u5668", (Object)adapter, (Object)ID);
            return;
        }
        String bucket1 = this.environment.getProperty("guthon.file-service.oss.ali.private-bucket");
        String bucket2 = this.environment.getProperty("guthon.file-service.oss.ali.public-bucket");
        String region = this.environment.getProperty("guthon.file-service.oss.ali.region");
        String endpoint = this.environment.getProperty("guthon.file-service.oss.ali.endpoint");
        String ak = this.environment.getProperty("guthon.file-service.oss.ali.access-key");
        String sk = this.environment.getProperty("guthon.file-service.oss.ali.secret-key");
        String supportCname = this.environment.getProperty("guthon.file-service.oss.ali.support-cname");
        String signatureVersion = this.environment.getProperty("guthon.file-service.oss.ali.signature-version");
        if (StringUtil.isNull((Object)supportCname)) {
            supportCname = "true";
        }
        if (StringUtil.isNull((Object)signatureVersion)) {
            signatureVersion = "4";
        }
        if (StringUtil.isNull((Object)endpoint)) {
            BaseException.throwException((String)"\u4e91\u5b58\u50a8\u6587\u4ef6\u670d\u52a1\u914d\u7f6e\u9519\u8bef\uff0c\u6587\u4ef6\u670d\u52a1\u7aef\u70b9[{}]\u672a\u914d\u7f6e", (Object[])new Object[]{"guthon.file-service.oss.ali.endpoint"});
        }
        if (StringUtil.isNull((Object)bucket1)) {
            BaseException.throwException((String)"\u4e91\u5b58\u50a8\u6587\u4ef6\u670d\u52a1\u914d\u7f6e\u9519\u8bef\uff0c\u79c1\u5bc6\u6876\u7f16\u7801[{}]\u672a\u914d\u7f6e", (Object[])new Object[]{"guthon.file-service.oss.ali.private-bucket"});
        }
        if (StringUtil.isNull((Object)bucket2)) {
            BaseException.throwException((String)"\u4e91\u5b58\u50a8\u6587\u4ef6\u670d\u52a1\u914d\u7f6e\u9519\u8bef\uff0c\u516c\u6709\u6876\u7f16\u7801[{}]\u672a\u914d\u7f6e", (Object[])new Object[]{"guthon.file-service.oss.ali.public-bucket"});
        }
        if (StringUtil.isNull((Object)ak)) {
            BaseException.throwException((String)"\u4e91\u5b58\u50a8\u6587\u4ef6\u670d\u52a1\u914d\u7f6e\u9519\u8bef\uff0c\u79d8\u94a5\u7f16\u7801[{}]\u672a\u914d\u7f6e", (Object[])new Object[]{"guthon.file-service.oss.ali.access-key"});
        }
        if (StringUtil.isNull((Object)sk)) {
            BaseException.throwException((String)"\u4e91\u5b58\u50a8\u6587\u4ef6\u670d\u52a1\u914d\u7f6e\u9519\u8bef\uff0c\u79c1\u94a5\u7f16\u7801[{}]\u672a\u914d\u7f6e", (Object[])new Object[]{"guthon.file-service.oss.ali.secret-key"});
        }
        this.initProxy();
        AliOSS.getInstance().init(bucket1, bucket2, ak, sk, endpoint, region, supportCname.equals("true"), Integer.parseInt(signatureVersion));
    }

    private void initProxy() {
        String host = this.environment.getProperty("golden.system.proxy.host");
        String port = this.environment.getProperty("golden.system.proxy.port");
        if (StringUtil.isBlankOne((Object[])new Object[]{host, port}).booleanValue()) {
            return;
        }
        String userName = this.environment.getProperty("golden.system.proxy.user-name");
        String password = this.environment.getProperty("golden.system.proxy.password");
        AliOSS.getInstance().initProxy(host, port, userName, password);
    }

    public void putFile(String filePath, byte[] buf) {
        AliOSS.getInstance().putFile(filePath, buf);
    }

    public void putFile(String filePath, File file) {
        AliOSS.getInstance().putFile(filePath, file);
    }

    public void putWebFile(String filePath, byte[] buf) {
        AliOSS.getInstance().putWebFile(filePath, buf);
    }

    public void putWebFile(String filePath, File file) {
        AliOSS.getInstance().putWebFile(filePath, file);
    }

    public File getTempFile(String filePath) {
        String temp = GdFilePath.getTempPath() + filePath;
        File file = new File(temp);
        file.getParentFile().mkdirs();
        AliOSS.getInstance().getFile(filePath, file);
        try {
            AliOSS.getInstance().delFile(filePath);
        }
        catch (Exception e) {
            this.log.error("\u5220\u9664\u4e34\u65f6\u6587\u4ef6[{}]\u5931\u8d25\uff1a{}", (Object)filePath, (Object)e.getMessage());
        }
        return file;
    }

    public void removeTempFile(String filePath) {
        try {
            AliOSS.getInstance().delFile(filePath);
        }
        catch (Exception e) {
            this.log.error("\u5220\u9664\u4e34\u65f6\u6587\u4ef6[{}]\u5931\u8d25\uff1a{}", (Object)filePath, (Object)e.getMessage());
        }
    }

    public int delWebFile(String filePath) {
        try {
            AliOSS.getInstance().delWebFile(filePath);
            return 0;
        }
        catch (Exception e) {
            this.log.error("\u5220\u9664\u6587\u4ef6[{}]\u5931\u8d25\uff1a{}", (Object)filePath, (Object)e.getMessage());
            return 1;
        }
    }

    public int delFile(String filePath) {
        try {
            AliOSS.getInstance().delFile(filePath);
            return 0;
        }
        catch (Exception e) {
            this.log.error("\u5220\u9664\u6587\u4ef6[{}]\u5931\u8d25\uff1a{}", (Object)filePath, (Object)e.getMessage());
            return 1;
        }
    }

    public File downloadFileToTemp(String filePath) {
        File file = new File(filePath);
        String tempFile = GdFilePath.getRandTempPath();
        file = new File(tempFile, file.getName());
        file.getParentFile().mkdirs();
        try {
            AliOSS.getInstance().getFile(filePath, file);
        }
        catch (Exception e) {
            this.log.error("\u4e0b\u8f7d\u6587\u4ef6[{}]\u5931\u8d25\uff1a{}", (Object)filePath, (Object)e.getMessage());
            return null;
        }
        return file;
    }

    public File downloadWebFileToTemp(String filePath) {
        File file = new File(filePath);
        String tempFile = GdFilePath.getRandTempPath();
        file = new File(tempFile, file.getName());
        file.getParentFile().mkdirs();
        try {
            AliOSS.getInstance().getWebFile(filePath, file);
        }
        catch (Exception e) {
            this.log.error("\u4e0b\u8f7d\u6587\u4ef6[{}]\u5931\u8d25\uff1a{}", (Object)filePath, (Object)e.getMessage());
            return null;
        }
        return file;
    }

    public byte[] getFile(String filePath) {
        try {
            return AliOSS.getInstance().getFile(filePath);
        }
        catch (Exception e) {
            this.log.error("\u4e0b\u8f7d\u6587\u4ef6[{}]\u5931\u8d25\uff1a{}", (Object)filePath, (Object)e.getMessage());
            return null;
        }
    }

    public byte[] getWebFile(String filePath) {
        try {
            return AliOSS.getInstance().getWebFile(filePath);
        }
        catch (Exception e) {
            this.log.error("\u4e0b\u8f7d\u6587\u4ef6[{}]\u5931\u8d25\uff1a{}", (Object)filePath, (Object)e.getMessage());
            return null;
        }
    }

    public String getFileUrl(String url, String disName, String desKey) {
        return AliOSS.getInstance().getFileUrl(url);
    }

    public String getWebFileUrl(String url) {
        return url;
    }
}

