/*
 * Decompiled with CFR 0.152.
 */
package com.guthon.plugin.oss.ali.util;

import com.aliyun.oss.ClientBuilderConfiguration;
import com.aliyun.oss.ClientConfiguration;
import com.aliyun.oss.OSS;
import com.aliyun.oss.OSSClientBuilder;
import com.aliyun.oss.common.auth.DefaultCredentialProvider;
import com.aliyun.oss.common.comm.SignVersion;
import com.aliyun.oss.model.Bucket;
import com.aliyun.oss.model.GetObjectRequest;
import com.aliyun.oss.model.ListObjectsV2Result;
import com.aliyun.oss.model.OSSObject;
import com.golden.faas.core.common.cache.SystemRunHook;
import com.golden.framework.boot.core.components.BaseBusiness;
import com.golden.framework.boot.utils.exception.BaseException;
import com.golden.framework.boot.utils.utils.StringUtil;
import com.golden.framework.boot.utils.utils.files.FileUtil;
import com.golden.framework.boot.utils.utils.tools.Format;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.Date;
import java.util.List;

public class AliOSS
extends BaseBusiness {
    private static final AliOSS instance = new AliOSS();
    private OSS client;
    private boolean isInit = false;
    private Object lock = new Object();
    private String bucket1;
    private String bucket2;
    private String ak;
    private String sk;
    private String region = "";
    private String endpoint;
    private String proxyHost;
    private String proxyPort;
    private String proxyUser;
    private String proxyPass;
    private boolean supportCname;
    private int signatureVersion;

    public static AliOSS getInstance() {
        return instance;
    }

    private String clearPathHead(String path) {
        if (!path.startsWith("/")) {
            return path;
        }
        return path.substring(1);
    }

    public void init(String bucket1, String bucket2, String ak, String sk, String endpoint, String region, boolean supportCname, int signatureVersion) {
        this.bucket1 = bucket1;
        this.bucket2 = bucket2;
        this.ak = ak;
        this.sk = sk;
        this.endpoint = endpoint;
        this.region = null == region ? "" : region;
        this.supportCname = supportCname;
        this.signatureVersion = signatureVersion;
        this.isInit = true;
    }

    public void initProxy(String host, String port, String userName, String password) {
        if (StringUtil.isBlankOne((Object[])new Object[]{host, port}).booleanValue()) {
            return;
        }
        this.proxyHost = host;
        this.proxyPort = port;
        if (StringUtil.isBlankOne((Object[])new Object[]{userName, password}).booleanValue()) {
            return;
        }
        this.proxyUser = userName;
        this.proxyPass = password;
    }

    public void connect() {
        if (!this.isInit) {
            BaseException.throwException((String)"\u5f53\u524d\u4e91\u5b58\u50a8\u672a\u521d\u59cb\u5316\u53c2\u6570\uff0c\u8bf7\u73b0\u521d\u59cb\u5316\u53c2\u6570\u540e\u518d\u8fde\u63a5");
        }
        if (null != this.client) {
            this.shutdown();
        }
        DefaultCredentialProvider provider = new DefaultCredentialProvider(this.ak, this.sk);
        ClientBuilderConfiguration clientBuilderConfiguration = new ClientBuilderConfiguration();
        if (1 == this.signatureVersion) {
            clientBuilderConfiguration.setSignatureVersion(SignVersion.V1);
        } else if (2 == this.signatureVersion) {
            clientBuilderConfiguration.setSignatureVersion(SignVersion.V2);
        } else {
            clientBuilderConfiguration.setSignatureVersion(SignVersion.V4);
        }
        clientBuilderConfiguration.setSupportCname(this.supportCname);
        OSSClientBuilder.OSSClientBuilderImpl builder = OSSClientBuilder.create();
        builder.credentialsProvider(provider);
        builder.clientConfiguration(clientBuilderConfiguration);
        builder.region(this.region);
        builder.endpoint(this.endpoint);
        this.initProxy(clientBuilderConfiguration);
        this.client = builder.build();
    }

    private void initProxy(ClientConfiguration clientConfig) {
        if (null == clientConfig) {
            return;
        }
        if (StringUtil.isNull((Object)this.proxyHost)) {
            return;
        }
        clientConfig.setProxyHost(this.proxyHost);
        clientConfig.setProxyPort(Integer.parseInt(this.proxyPort));
        if (StringUtil.isBlankOne((Object[])new Object[]{this.proxyUser, this.proxyPass}).booleanValue()) {
            return;
        }
        clientConfig.setProxyUsername(this.proxyUser);
        clientConfig.setProxyPassword(this.proxyPass);
    }

    public OSS getClient() {
        return this.client;
    }

    public void putFile(String path, File file) {
        this.putFile(this.bucket1, path, file);
    }

    public void putFile(String path, byte[] buffer) {
        this.putFile(this.bucket1, path, buffer);
    }

    public void putWebFile(String path, byte[] buffer) {
        this.putFile(this.bucket2, path, buffer);
    }

    public void putWebFile(String path, File file) {
        this.putFile(this.bucket2, path, file);
    }

    private void putFile(String bucket, String path, byte[] buffer) {
        ByteArrayInputStream is = new ByteArrayInputStream(buffer);
        this.putFile(bucket, path, is);
        FileUtil.close((Closeable)is);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putFile(String bucket, String path, File file) {
        FileInputStream is = null;
        try {
            is = new FileInputStream(file);
            this.putFile(bucket, path, is);
        }
        catch (Exception e) {
            try {
                this.log.error(e.getMessage(), (Throwable)e);
                BaseException.throwException((String)"\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25\uff1a{}", (Object[])new Object[]{e.getMessage()});
            }
            catch (Throwable throwable) {
                FileUtil.close(is);
                throw throwable;
            }
            FileUtil.close((Closeable)is);
        }
        FileUtil.close((Closeable)is);
    }

    private void putFile(String bucket, String path, InputStream is) {
        this.checkConnect();
        try {
            path = this.clearPathHead(path);
            this.client.putObject(bucket, path, is);
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            BaseException.throwException((String)"\u4e0a\u4f20\u6587\u4ef6[{}]\u5931\u8d25\uff1a{}", (Object[])new Object[]{path, e.getMessage()});
        }
    }

    public byte[] getFile(String path) {
        return this.getFile(this.bucket1, path);
    }

    public byte[] getWebFile(String path) {
        return this.getFile(this.bucket2, path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] getFile(String bucket, String path) {
        this.checkConnect();
        path = this.clearPathHead(path);
        GetObjectRequest request = new GetObjectRequest(bucket, path);
        OSSObject result = null;
        try {
            result = this.client.getObject(request);
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            BaseException.throwException((String)"\u8bfb\u53d6\u6587\u4ef6[{}]\u5931\u8d25\uff1a{}", (Object[])new Object[]{path, e.getMessage()});
            return null;
        }
        ByteArrayOutputStream bs = new ByteArrayOutputStream();
        InputStream in = result.getObjectContent();
        try {
            byte[] buffer;
            int r;
            while ((r = in.read(buffer = new byte[524288])) > 0) {
                bs.write(buffer, 0, r);
            }
            buffer = bs.toByteArray();
            return buffer;
        }
        catch (Exception e) {
            BaseException.throwException((String)"\u8bfb\u53d6\u6587\u4ef6[{}]\u5931\u8d25\uff1a{}", (Object[])new Object[]{path, e.getMessage()});
            byte[] byArray = null;
            return byArray;
        }
        finally {
            FileUtil.close((Closeable)in);
            FileUtil.close((Closeable)bs);
            FileUtil.close((Closeable)result);
        }
    }

    public void getFile(String path, File file) {
        this.getFile(this.bucket1, path, file);
    }

    public void getWebFile(String path, File file) {
        this.getFile(this.bucket2, path, file);
    }

    private void getFile(String bucket, String path, File file) {
        this.checkConnect();
        path = this.clearPathHead(path);
        GetObjectRequest request = new GetObjectRequest(bucket, path);
        try {
            this.client.getObject(request, file);
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            BaseException.throwException((String)"\u8bfb\u53d6\u6587\u4ef6[{}]\u5931\u8d25\uff1a{}", (Object[])new Object[]{path, e.getMessage()});
        }
    }

    public void delFile(String filePath) {
        this.delFile(this.bucket1, filePath);
    }

    public void delWebFile(String filePath) {
        this.delFile(this.bucket2, filePath);
    }

    private void delFile(String bucket, String path) {
        this.checkConnect();
        try {
            path = this.clearPathHead(path);
            this.client.deleteObject(bucket, path);
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            BaseException.throwException((String)e.getMessage());
        }
    }

    public String getFileUrl(String path) {
        this.checkConnect();
        Date d = Format.dateAdd((Date)new Date(), (int)7);
        path = this.clearPathHead(path);
        URL url = this.client.generatePresignedUrl(this.bucket1, path, d);
        String stru = url.toString();
        return stru;
    }

    public ListObjectsV2Result listObjects() {
        this.checkConnect();
        return this.client.listObjectsV2(this.bucket1);
    }

    public List<Bucket> listBuckets() {
        this.checkConnect();
        return this.client.listBuckets();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkConnect() {
        if (null != this.client) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            if (null != this.client) {
                return;
            }
            this.connect();
        }
    }

    private AliOSS() {
        SystemRunHook.addShutdownHook(() -> this.shutdown());
    }

    public void shutdown() {
        if (null == this.client) {
            return;
        }
        try {
            this.client.shutdown();
            this.client = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

